/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.util;

import java.util.HashMap;

import javax.xml.transform.Transformer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import gov.va.caret.service.ctssh.template.Template;

/**
 *
 * @author ronaday
 */
public class CacheHandler {
    
    /**
     * 
     */
    private static final CacheHandler sngleton = new CacheHandler();
    
    /**
     * 
     */
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    /**
     * 
     */
    private final HashMap<String, XPathExpression> xcache = new HashMap<>();
    private final HashMap<String, Transformer> xformcache = new HashMap<>();
    /**
     * 
     */
    private final HashMap<String, Template> tcache = new HashMap<>();

    
    /**
     * @return
     */
    public static CacheHandler instance()
    {
        return sngleton;
    }
    
    /**
     * 
     */
    private CacheHandler()
    {
        //do nada here
    }
    
    /**
     * @param _key
     * @param _xpath
     * @throws Exception
     */
    public void cacheXPath(String _key, String _xpath) throws Exception
    {
        try {
        if(!xcache.containsKey(_key))
            xcache.put(_key, xpath.compile(_xpath));
        
        }catch(Exception e)
        {
        	AppHelper.log("ERROR : " + _xpath);
            throw e;
        }
    }
    
    /**
     * @param _key
     * @param _t
     */
    public void cacheTemplate(String _key, Template _t)
    {
        if(!tcache.containsKey(_key))
            tcache.put(_key, _t);
    }

    public void cacheXform(String _key, Transformer _t)
    {
        if(!xformcache.containsKey(_key))
        	xformcache.put(_key, _t);
    }

    /**
     * @param _key
     * @return
     * @throws Exception
     */
    public XPathExpression getXPath(String _key) throws Exception
    {
    	
    	if(!xcache.containsKey(_key))
    		cacheXPath(_key,_key);
    	
        return xcache.get(_key);
    }
    
    /**
     * @param _key
     * @return
     */
    public Template getTemplate(String _key)
    {
        return tcache.get(_key);
    }

    public Transformer getTransform(String _key)
    {
        return xformcache.get(_key);
    }
    
    
    /**
     * @param key
     * @return
     */
    public boolean isValidTemplateKey(String key) {
        return tcache.containsKey(key);
    }
    
    
    
}
